// Autor: Stjepan Glavina

#include <cstdio>
#include <cstring>
#include <cassert>

#include <algorithm>
#include <iostream>
using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long llint;

const vector<string> KOD = {
  "11111110.01111111",
  "10000010.01000001",
  "10111010.01011101",
  "10111010.01011101",
  "10111010.01011101",
  "10000010.01000001",
  "11111110.01111111",
  "00000000.00000000",
  "........11111....",
  "0000000010001....",
  "1111111010101....",
  "1000001010001....",
  "1011101011111....",
  "10111010.........",
  "10111010.........",
  "10000010.........",
  "11111110.........",
};

void expand(vector<string> &kod) {
  int N = kod.size();
  kod.insert(kod.begin()+8, string(N, '.'));
  REP(i, N+1) kod[i].insert(kod[i].begin()+8, '.');
}

int N;
char g[111][111];

bool inside(int x, int y, vector<string> &kod) {
  int m = kod.size();
  REP(i, m) REP(j, m)
    if (kod[i][j] != '.' && g[x+i][y+j] != kod[i][j])
      return false;
  return true;
}

int main() {
  scanf("%d", &N);
  REP(i, N) scanf("%s", g[i]);
  REP(i, N) REP(j, N) g[i][j] = '0' + (g[i][j]=='#');

  auto kod = KOD;
  for (;;) {
    REP(step, 4) {
      int m = kod.size();
      assert(m <= N);

      REP(x, N-m+1) REP(y, N-m+1) if (inside(x, y, kod)) {
        string out;
        REP(j, m) REP(i, m) if (kod[i][j] == '.') out += g[x+i][y+j];
        reverse(out.begin(), out.end());

        puts(out.c_str());
        return 0;
      }

      REP(i, N) REP(j, i) swap(g[i][j], g[j][i]);
      REP(i, N) reverse(g[i], g[i]+N);
    }
    expand(kod);
  }

  return 0;
}
